#file: main.py
#Copyright (C) 2004 Free Software Foundation
#see GPL.txt for license.

#This file controls the wilderness and dungeon.

from Tkinter import *
#needed for the tiles.
import ImageTk
import Image
#needed for random battles
from random import random
#needed for dialog boxes
import tkMessageBox

#local imports.
import g
import inv
import battle
import shop
import action

#size, in tiles, of the main screen. While this is adjustable,
#an odd number would work much better. (Keep the player centered.)
mapsize = 13

sidebarsize = 5
status_box_width = 19
width = 20
status_box_height =10


#max number of messages to keep.
max_messages = 20

#number of free moves after attack left.
global free_move


name = StringVar()
hp = StringVar()
ep = StringVar()
attack = StringVar()
defense = StringVar()
gold = StringVar()
exp = StringVar()
level = StringVar()




#print a message in status box
def print_message(message):
	try:
		if window_main.state() != "normal":
			return 0
		listbox_status.insert(END, message)
		listbox_status.see(END)

		if listbox_status.size() > max_messages:
			listbox_status.delete(0, listbox_status.size() - max_messages -1)
		return 1
	except NameError:
		return 0

#save game
def save_game(event=0):
	g.savegame(g.name)
	print_message("** Game Saved **");

#determine if the player is dead, and, if so, end the game.
def dead_yet():
	#did you die?
	if g.hp <= 0:
		action.activate_line(g.xgrid, g.ygrid, g.zgrid, "die")
		return 1

#back to main menu. Called on death.
def close_window(event=0):
	if g.hp < 1 or show_yesno("Leave this game?"):
		try:
			window_main.destroy()
		except TclError:
			pass

#Activate any scripting associated with a tile. X and Y are relative
#to the location of the player.
#assumes scripting stored in maps[zgrid].tiles[checklocation(x, y)].actions[]
def activate_scripting(x, y, z):
	tile_type = g.checklocation(x, y)
	return_num = 0
	temp_zgrid = z
	#if there are no actions, leave immediately
	if len(g.maps[temp_zgrid].tiles[tile_type].actions) == 0: return
	i = 0
	#go through all action lines.
	while i < len(g.maps[temp_zgrid].tiles[tile_type].actions):
		temp = action.activate_line(x, y, z,
			g.maps[temp_zgrid].tiles[tile_type].actions[i])
		if temp == "end": break
		if dead_yet() == 1:
			break
		i += 1
	return return_num

#redraws the main map. Call after moving.
def refreshmap():
	#redraw the tiles
	for x in range(mapsize):
		for y in range(mapsize):
			type = g.checklocation(x-mapsize/2, y-mapsize/2)
			label_map[y*mapsize+x].config(image=findtile(x-mapsize/2,
				y-mapsize/2))

	canvas_char.delete("all")
	canvas_char.create_image(0, 0, anchor=NW, image=findtile(0, 0))
	canvas_char.create_image(0, 0, anchor=NW, image=g.tiles[g.cur_hero])

	recalc_stats()

#called to process the onload portion of a level. Called whenever entering
#a level. Set g.zgrid properly before calling.
def process_onload():
	for tile_type in g.maps[g.zgrid].tiles:
		return_num = 0
		#if there are no actions, leave immediately
		if len(g.maps[g.zgrid].tiles[tile_type].onload) == 0: return
		i = 0
		#go through all action lines.
		for i in range(len(g.maps[g.zgrid].tiles[tile_type].onload)):
			temp = action.activate_line(-1, -1, g.zgrid,
				g.maps[g.zgrid].tiles[tile_type].onload[i], tile_type)

#recalculate and display stats
def recalc_stats():
	#hp/ep bars
	canvas_hp.delete("show_hp")
	temp_width = g.hpbar_width*g.hp/g.maxhp
	if temp_width < 0: temp_width=0
	canvas_hp.create_rectangle(0, 0, temp_width,
		g.hpbar_width/6, fill="#05BB05", tags="show_hp")
	canvas_ep.delete("show_ep")
	temp_width = g.hpbar_width*g.ep/g.maxep
	if temp_width < 0: temp_width=0
	canvas_ep.create_rectangle(0, 0, temp_width,
		g.hpbar_width/6, fill="#0505EE", tags="show_ep")


	hp.set(str(g.hp) + "/" + str(g.maxhp))
	ep.set(str(g.ep) + "/" + str(g.maxep))
	g.adj_attack = int(g.attack)

	#adjust attack and defense based on equipment.
	if g.equip[0] != -1:
		g.adj_attack = g.adj_attack + g.item[g.equip[0]][2]
	attack.set(g.adj_attack)

	g.adj_defense = int(g.defense)
	for i in range(1, 6):
		if g.equip[i] != -1:
			g.adj_defense = g.adj_defense + g.item[g.equip[i]][2]
	defense.set(g.adj_defense)
	gold.set(g.gold)
	exp.set(g.exp)
	level.set(g.level)

#takes x and y relative to the player, and returns the image needed
#to display that location.
def findtile(x, y):
	#transform from relative to absolute coordinates
	x = g.xgrid + x
	y = g.ygrid + y

	#Assume that all off-map areas are rock.
	if x < 0 or y < 0:
		return g.maps[g.zgrid].tiles["1"].pix
	try:
		#this will fail when looking too far right or down
		return g.maps[g.zgrid].tiles[g.maps[g.zgrid].field[y][x]].pix
	except IndexError:
		#If it fails, there is rock there.
		return g.maps[g.zgrid].tiles["1"].pix
	except KeyError:
		#if the author forgot to define the tile, point out the mistake.
		print "Tile of " + g.maps[g.zgrid].field[y][x] + " is not defined" \
			+ " in map " + g.maps[g.zgrid].name
		return g.maps[g.zgrid].tiles["1"].pix



#movement commands. Check to see if window_main is visible, and if there is no
#dialog box showing, then if travel is possible to a spot, move there.
#requires the change in xy coordinates. Called with move_north and the like.
def move_hero(x, y):
	try:
		#check for either the main window not existing, or a current dialog
		if window_main.state() != "normal" or action.has_dialog == 1:
			return

		#check for any objects of interest.
		activate_scripting(x, y, g.zgrid)

		if g.iswalkable(x, y) != '1':
			if g.allow_move == 1:
				g.xgrid=g.xgrid + x
				g.ygrid=g.ygrid + y
				passturn()
				if y == -1: g.cur_hero = "hero_n.png"
				if y ==  1: g.cur_hero = "hero_s.png"
				if x == -1: g.cur_hero = "hero_w.png"
				if x ==  1: g.cur_hero = "hero_e.png"
				refreshmap()
		else:
			if y == -1: g.cur_hero = "hero_n.png"
			if y ==  1: g.cur_hero = "hero_s.png"
			if x == -1: g.cur_hero = "hero_w.png"
			if x ==  1: g.cur_hero = "hero_e.png"
			refreshmap()
		g.allow_move = 1
	except TclError:
		pass


def move_north(event=0): move_hero(0, -1)
def move_east(event=0):  move_hero(1, 0)
def move_south(event=0): move_hero(0, 1)
def move_west(event=0):  move_hero(-1, 0)


#called at the end of movement. Controls the passing of time.
def passturn():
	global free_move

	#handle timed effects
	g.timestep = g.timestep + 1
	if g.timestep%5 == 0:
		g.hp = g.hp + 3 + g.level/3
	if g.timestep%6 == 0:
		g.ep = g.ep + 1 + g.level/3
	if g.timestep > 60: g.timestep = g.timestep - 60
	if g.hp >= g.maxhp: g.hp = g.maxhp
	if g.ep >= g.maxep: g.ep = g.maxep


	#is there a monster here?
	chance = random() * 100
	#allow free moves after attack
	if free_move > 0:
		free_move = free_move - 1
		chance = 99

	if chance < 15:
		#battle
		temp = g.find_level_monster(g.zgrid)
		#if there exists a monster to battle:
		if temp != -1:
			start_battle(temp)
			if dead_yet() != 1:
				refreshmap()



#Starts a battle. Takes the index of the monster in g.monster
def start_battle(mon_index):
	global free_move
	right.destroy()
	button_inv.config(state=DISABLED)
	button_save.config(state=DISABLED)
	if battle.begin(mon_index) == 1:  #if you ran, you failed
		return_num = 0
	else:
		return_num = 1  #otherwise, you succeeded.
	#number of free moves after attack:
	free_move = 2
	button_inv.config(state=NORMAL)
	button_save.config(state=NORMAL)
	create_map()
	refreshmap()
	bind_keys()
	return return_num


#Call to display a dialog box. Used to work with action.py.
#Note this only works if window_main is visible.
def show_dialog(line=None):
	if window_main.state() != "normal":
		return 0
	tkMessageBox.showinfo(g.game_name, line, parent=window_main)
	return 1

def show_yesno(line=None):
	if window_main.state() != "normal":
		return 0
	return tkMessageBox.askyesno(g.game_name, line, parent=window_main)

#call to create window_main.
def init_window_main(new_game = 0):
	global window_main
	global top
	window_main = Toplevel()
	global bgcolour
	bgcolour="lightgrey"
	global buttoncolour
	buttoncolour="lightgrey"
	global statusboxcolour
	statusboxcolour = "lightgrey"

	main_frame = Frame(window_main, bg=bgcolour)
	main_frame.grid(row=0, column=0)

	#top frame contains left and right
	top = Frame(main_frame, bd=2, relief=SUNKEN, bg=bgcolour);
	top.grid(row=0, column=0, columnspan=width, sticky=NW)

	#status window, scrollbar
	global move_scroll
	global listbox_status
	listbox_status = Listbox(window_main, height=status_box_height,
		bg=statusboxcolour)
	listbox_status.grid(row=1, column=0, sticky=EW) #status_box_width)
	move_scroll = Scrollbar(window_main, orient=VERTICAL,
		command=listbox_status.yview, bg=statusboxcolour)
	move_scroll.grid(row=1, column=0, sticky=N+S+E)
	listbox_status.config(yscrollcommand=move_scroll.set)


	g.load_tiles()

	#At this point, the actual files are in tiles[filename]
	#Assign pictures to actual tiles.
	for mapindex in range(len(g.maps)):
		for tilename in g.maps[mapindex].tiles:
			 g.maps[mapindex].tiles[tilename].pix = \
			 	g.tiles[g.maps[mapindex].tiles[tilename].pixname]
	#now each tile has a name and an actual picture.

	#width of the hp/ep bars.
	g.hpbar_width = g.tiles["grass.png"].width()*3

	name.set(g.name)

	#left (stats) side frame
	global left
	left = Frame(top, bg=bgcolour);
	left.grid(row=1, column=0, columnspan=sidebarsize, sticky=NW)

	#formatting for the labels.
	label_formatting = Label(left, text="Name:", bg=bgcolour).grid(row=5,
		column=1, sticky=E)
	label_formatting = Label(left, text="HP:", bg=bgcolour).grid(row=6,
		column=1, sticky=E)
	label_formatting = Label(left, text="EP:", bg=bgcolour).grid(row=8,
		column=1, sticky=E)
	label_formatting = Label(left, text="Attack:", bg=bgcolour).grid(row=10,
		column=1, sticky=E)
	label_formatting = Label(left, text="Defense:", bg=bgcolour).grid(row=11,
		column=1, sticky=E)
	label_formatting = Label(left, text="Gold:", bg=bgcolour).grid(row=12,
		column=1, sticky=E)
	label_formatting = Label(left, text="Exp:", bg=bgcolour).grid(row=13,
		column=1, sticky=E)
	label_formatting = Label(left, text="Level:", bg=bgcolour).grid(row=14,
		column=1, sticky=E)

	#display of stats
	label_name = Label(left, textvariable=name, bg=bgcolour).grid(row=5,
		column=2, sticky=W)

	global canvas_hp
	canvas_hp = Canvas(left, width=g.hpbar_width,
		height=g.hpbar_width/6, highlightthickness=0)
	canvas_hp.grid(column=1, row=7, columnspan=2, sticky=W, padx=5)
	canvas_hp.create_rectangle(0, 0, g.hpbar_width,
		g.hpbar_width/2, fill="#EE0505")
	global canvas_ep
	canvas_ep = Canvas(left, width=g.hpbar_width,
		height=g.hpbar_width/6, highlightthickness=0)
	canvas_ep.grid(column=1, row=9, columnspan=2, sticky=W, padx=5)
	canvas_ep.create_rectangle(0, 0, g.hpbar_width,
		g.hpbar_width/2, fill="#EE0505")

	label_hp = Label(left, textvariable=hp, bg=bgcolour).grid(row=6,
		column=2, sticky=W)
	label_ep = Label(left, textvariable=ep, bg=bgcolour).grid(row=8,
		column=2, sticky=W)
	label_attack = Label(left, textvariable=attack, bg=bgcolour).grid(row=10,
		column=2, sticky=W)
	label_defense = Label(left, textvariable=defense, bg=bgcolour).grid(row=11,
		column=2, sticky=W)
	label_gold = Label(left, textvariable=gold, bg=bgcolour).grid(row=12,
		column=2, sticky=W)
	label_exp = Label(left, textvariable=exp, bg=bgcolour).grid(row=13,
		column=2, sticky=W)
	label_level = Label(left, textvariable=level, bg=bgcolour).grid(row=14,
		column=2, sticky=W)


	#inventory and movement buttons.
	global button_inv #global because we need to disable it sometimes.
	global button_save
	button_inv = Button(left, text="Inventory", underline="0",
		command=show_inv, bg=buttoncolour)
	button_inv.grid(row=15, column=1, columnspan=2, sticky=EW)
	button_save = Button(left, text="Save", underline="0",
		command=save_game, bg=buttoncolour)
	button_save.grid(row=16, column=1, columnspan=2, sticky=EW)
	button_quit = Button(left, text="Quit", underline="0",
		command=close_window, bg=buttoncolour).grid(row=17, column=1,
			columnspan=2, sticky=EW)
	#this creates the actual map portion.
	create_map()

	#put in the map, and do finishing touches on the window.
	process_onload()
	g.cur_hero = "hero_w.png"
	refreshmap()
	window_main.wm_geometry("+%d+%d" % (10, 10))
	window_main.focus()
	window_main.resizable(0, 0)
	window_main.title(g.game_name)
	global free_move
	free_move = 0

	bind_keys()

	#call newgame script
	if new_game == 1:
		for line in g.newgame_act:
			action.activate_line(g.xgrid, g.ygrid, g.zgrid, line)
	g.allow_move = 1
	action.has_dialog = 0

	#keep the new_game window asleep until this one is closed.
	window_main.master.wait_window(window_main)

def do_nothing(event=0):
	pass

#this binds keys to the appropriate commands. Needs to be called after
#returning from various subwindows.
def bind_keys():
	window_main.bind("<Up>", move_north)
	window_main.bind("<Right>", move_east)
	window_main.bind("<Left>", move_west)
	window_main.bind("<Down>", move_south)
	window_main.bind("<Escape>", close_window)
	window_main.bind("i", show_inv)
	window_main.bind("a", do_nothing)
	window_main.bind("s", save_game)
	window_main.bind("q", close_window)
	window_main.bind("<Return>", show_inv)



def create_map():
	#right side frame contains map
	global right
	right = Frame(top,bd=2, relief=SUNKEN, bg=bgcolour);
	right.grid(row=1, column=sidebarsize, columnspan=mapsize, sticky=E)

	#this creates the actual map portion.
	global label_map
	label_map = []
	for x in range(mapsize):
		for y in range(mapsize):
			label_map.append(x*mapsize+y)
			label_map[x*mapsize+y] = Label(right,
				image=g.tiles["blank"], borderwidth=0)
			if (x < y): #north or east
				if (x + y > mapsize-1): #east
					label_map[x*mapsize+y].bind("<Button-1>", move_east)
				elif(x + y < mapsize-1): #north
					label_map[x*mapsize+y].bind("<Button-1>", move_north)
			elif (x > y): #south or west
				if (x + y > mapsize-1): #south
					label_map[x*mapsize+y].bind("<Button-1>", move_south)
				elif(x + y < mapsize-1): #west
					label_map[x*mapsize+y].bind("<Button-1>", move_west)
			label_map[x*mapsize+y].grid(column=y, row=x)


	#this creates the transparent Player tile.
	global canvas_char
	canvas_char = Canvas(right, width=g.tiles["grass.png"].width(),
		height=g.tiles["grass.png"].height(), highlightthickness=0)
	canvas_char.grid(column=mapsize/2, row=mapsize/2)

#show the inventory.
def show_inv(event=0):
	try:
		if window_main.state() != "normal" or action.has_dialog == 1:
			return
		right.destroy()
		button_inv.config(state=DISABLED)
		button_save.config(state=DISABLED)
		inv.init_window_inv()
		button_inv.config(state=NORMAL)
		button_save.config(state=NORMAL)
		create_map()
		refreshmap()
		recalc_stats()
		bind_keys()
	except TclError:
		pass

def enter_store(cur_loc):
	right.destroy()
	button_inv.config(state=DISABLED)
	button_save.config(state=DISABLED)
	shop.init_window_shop(cur_loc)
	button_inv.config(state=NORMAL)
	button_save.config(state=NORMAL)
	create_map()
	refreshmap()
	recalc_stats()
	bind_keys()
